library ieee;
use ieee.std_logic_1164.all;

use ieee.numeric_std.all;
entity firref is
port (
  clk, reset : in std_logic;
  x_0 : in std_logic_vector(4 downto 0);
  y : out std_logic_vector(9 downto 0));
end firref;
architecture generated of firref is
component reg
generic (wordlength : positive);
port (
  clk, reset : in std_logic;
  d : in std_logic_vector(wordlength-1 downto 0);
  q : out std_logic_vector(wordlength-1 downto 0));
end component;
signal x_0_0 : std_logic_vector(4 downto 0);
signal x_0_1 : std_logic_vector(4 downto 0);
signal x_0_2 : std_logic_vector(4 downto 0);
signal x_0_3 : std_logic_vector(4 downto 0);
signal x_0_4 : std_logic_vector(4 downto 0);
signal x_0_5 : std_logic_vector(4 downto 0);
signal x_0_6 : std_logic_vector(4 downto 0);
signal prod_0_0 : std_logic_vector(9 downto 0);
signal prod_0_1 : std_logic_vector(9 downto 0);
signal prod_0_2 : std_logic_vector(9 downto 0);
signal prod_0_3 : std_logic_vector(9 downto 0);
signal prod_0_4 : std_logic_vector(9 downto 0);
signal prod_0_5 : std_logic_vector(9 downto 0);
signal prod_0_6 : std_logic_vector(9 downto 0);
signal sum_0 : std_logic_vector(9 downto 0);
signal sum_1 : std_logic_vector(9 downto 0);
signal sum_2 : std_logic_vector(9 downto 0);
signal sum_3 : std_logic_vector(9 downto 0);
signal sum_4 : std_logic_vector(9 downto 0);
constant c_0_0 : integer := -2;
constant c_0_1 : integer := 0;
constant c_0_2 : integer := 5;
constant c_0_3 : integer := 8;
constant c_0_4 : integer := 5;
constant c_0_5 : integer := 0;
constant c_0_6 : integer := -2;
begin
x_0_0 <= x_0;
xd_0_0_i : reg generic map(5) port map(clk, reset, x_0_0, x_0_1);
xd_0_1_i : reg generic map(5) port map(clk, reset, x_0_1, x_0_2);
xd_0_2_i : reg generic map(5) port map(clk, reset, x_0_2, x_0_3);
xd_0_3_i : reg generic map(5) port map(clk, reset, x_0_3, x_0_4);
xd_0_4_i : reg generic map(5) port map(clk, reset, x_0_4, x_0_5);
xd_0_5_i : reg generic map(5) port map(clk, reset, x_0_5, x_0_6);
prod_0_0 <= std_logic_vector(signed(x_0_0) * to_signed(c_0_0, 5));
prod_0_1 <= std_logic_vector(signed(x_0_1) * to_signed(c_0_1, 5));
prod_0_2 <= std_logic_vector(signed(x_0_2) * to_signed(c_0_2, 5));
prod_0_3 <= std_logic_vector(signed(x_0_3) * to_signed(c_0_3, 5));
prod_0_4 <= std_logic_vector(signed(x_0_4) * to_signed(c_0_4, 5));
prod_0_5 <= std_logic_vector(signed(x_0_5) * to_signed(c_0_5, 5));
prod_0_6 <= std_logic_vector(signed(x_0_6) * to_signed(c_0_6, 5));
sum_0 <= std_logic_vector(signed(prod_0_0) + signed(prod_0_1) + signed(prod_0_2) + signed(prod_0_3) + signed(prod_0_4) + signed(prod_0_5) + signed(prod_0_6));
sumd_0_i : reg generic map(10) port map(clk, reset, sum_0, sum_1);
sumd_1_i : reg generic map(10) port map(clk, reset, sum_1, sum_2);
sumd_2_i : reg generic map(10) port map(clk, reset, sum_2, sum_3);
sumd_3_i : reg generic map(10) port map(clk, reset, sum_3, sum_4);
y <= sum_4;
end generated;
